#!/bin/bash

if [[ ! -f "/proc/device-tree/dcpr" ]]; then
  exit 0
fi

LOG "Get IP address to master"
ip_controller=$(redis-cli -p 50002 get "${REDIS_DATA_HASH_TAG}":so:mounts | jq -r '.[] | to_entries | .[] | select(.value.status=="Master" and .value.instance_type=="CONF" and .value.node_type=="Controller") | .value.ip')
LOG "Got IP address to master" "${ip_controller}"

ports_add=()
LOG "Running CLOOP upgrade ports script."
for ((num = 1; num <= 96; num+=2))
do
  port_add=$(redis-cli -c -p 50001 dh.get "${REDIS_CONF_HASH_TAG}":dh/wss:config/module/add/channel/"${num}"/port | jq -r '.value')
  if test -z "$port_add"; then
    LOG "No WSS port found for " "${num}" "read portnumber " "${ports_add[num]}" "Aborting with error"
    exit 1
  else
    ports_add+=( "${port_add}" )
  fi;

done
LOG "The following ports are read from WSS " "${ports_add[@]}"

# use for loop to read all values and indexes
for (( num=1; num<=48; num++ ));
do
  PORTNAME=""
  if [[ "${ports_add[num-1]}" -eq 2 ]]; then
    PORTNAME="localAD"
  elif [[ "${ports_add[num-1]}" -eq 4 ]]; then
    PORTNAME="xc1"
  elif [[ "${ports_add[num-1]}" -eq 6 ]]; then
    PORTNAME="xc2"
  elif [[ "${ports_add[num-1]}" -eq 8 ]]; then
    PORTNAME="xc3"
  elif [[ "${ports_add[num-1]}" -eq 1 ]]; then
    PORTNAME="xc4Wss1"
  elif [[ "${ports_add[num-1]}" -eq 3 ]]; then
    PORTNAME="xc4Wss2"
  elif [[ "${ports_add[num-1]}" -eq 5 ]]; then
    PORTNAME="xc4Wss3"
  elif [[ "${ports_add[num-1]}" -eq 7 ]]; then
    PORTNAME="xc4Wss4"
  elif [[ "${ports_add[num-1]}" -eq 9 ]]; then
    PORTNAME="xc4Wss5"
  else
    LOG "Port name not possible to read for channel " "${num}" "read portnumber " "${ports_add[num-1]}"
    exit 1
  fi
  # Config new service key and set value of port in running database
  REDIS_PATH="config/client/${num}/wssPortName"
  NEW_NAME="{\"value\":\"${PORTNAME}\"}"
  if test -z "$ip_controller"; then
    set_options="-c -p 30001"
  else
    set_options="-h ${ip_controller} -c -p 50001"
  fi
  redis-cli ${set_options} DH.CREATE_CONFIG_KEY ${REDIS_CONF_HASH_TAG} dh/cloop ${REDIS_PATH} ${NEW_NAME} &> /dev/null
  redis-cli ${set_options} DH.SET               ${REDIS_CONF_HASH_TAG}:dh/cloop:${REDIS_PATH} ${NEW_NAME} &> /dev/null
  LOG "Having set portname" "${PORTNAME}" "on path" "${REDIS_CONF_HASH_TAG}" ":dh/cloop:" "${REDIS_PATH}" "with options" "${set_options}"
done
LOG "Converted WSS data to cloop data"
exit 0