#!/bin/bash

if [[ ! -f "/proc/device-tree/dcp2" ]]; then
  exit 0
fi

LOG "Running dcp2 automation mode upgrade script."
automationMode=$(redis-cli -c -p 50001 dh.get ${REDIS_CONF_HASH_TAG}:so/system/settings:config/automationMode)

if [ -z "$automationMode" ]; then
  automationMode_dh=$(redis-cli -c -p 50001 dh.get ${REDIS_CONF_HASH_TAG}:dh/system/settings:config/automationMode)
  if [ -z "$automationMode_dh" ]; then
    LOG "Error: automationMode do not exist"
    exit 1
  fi
  LOG "AutomationMode has already been updated"
  exit 0
fi

LOG "automationMode is $automationMode"

result=$(redis-cli -c -p 30001 DH.CREATE_CONFIG_KEY ${REDIS_CONF_HASH_TAG} dh/system/settings config/automationMode $automationMode)
if [[ "$result" != "OK" ]]; then
  LOG "Error: failed to create new key in database"
  exit 1
fi

result=$(redis-cli -c -p 30001 dh.set ${REDIS_CONF_HASH_TAG}:dh/system/settings:config/automationMode $automationMode)
if [[ "$result" != "OK" ]]; then
  LOG "Error: failed to write to new key in database"
  exit 1
fi

result=$(redis-cli -c -p 30001 DEL ${REDIS_CONF_HASH_TAG}:so/system/settings:config/automationMode)
if [[ "$result" != "1" ]]; then
  LOG "Error: failed to delete old automationMode key"
  exit 1
fi

LOG "Successfully completed dcp2 automation mode upgrade script."
exit 0
